package com.example.calc.diceshaker;    //Denkt auch hier wieder daran, dass hier euer Package Name steht, ansonsten gibts Probleme ;)

import android.content.pm.ActivityInfo;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.Random;


import java.io.IOException;

import android.app.Activity;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;




public class MainActivity extends Activity /*AppCompatActivity*/ implements SensorEventListener //, OnCheckedChangeListener
{

    private final static float ACC = 14; //unser Wert, bei dem das handy plötzlich stark geschüttelt wurde/wird
    private SensorManager sensor;
    private boolean switch_bool;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        ImageView bild = (ImageView) findViewById(R.id.imageView);
        bild.setImageResource(R.drawable.i_1_dice);
        this.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);

        switch_bool = true;
        sensor = (SensorManager) getSystemService(SENSOR_SERVICE);
    }


    @Override
    protected void onResume() {
        super.onResume();

        if ( switch_bool ) {
            registerSenser();
        }

    }

    @Override
    protected void onStop() {
        unregisterSenser();
        super.onStop();
    }

    @Override
    protected void onPause() {
        if ( switch_bool ) {
            unregisterSenser();
        }

        super.onPause();
    }

    @Override
    public void onAccuracyChanged(Sensor sensor, int accuracy) {
        // TODO Auto-generated method stub
        // Do nothing.
    }

    @Override
    public void onSensorChanged(SensorEvent event) {

        int sensorType = event.sensor.getType();

        // values[0]: X-Achse，    values[1]： Y-Achse，     values[2]： Z-Achse
        float[] values = event.values;

        if (sensorType == Sensor.TYPE_ACCELEROMETER) {

            /*
            Because under normal circumstances, the maximum value of any axis is between 9.8 ~ 10, only when you suddenly shake the phone, the instantaneous acceleration will suddenly increase or decrease.
            So, after the actual test, just listen to any axis acceleration greater than 14
             * */
            if ((Math.abs(values[0]) > ACC || Math.abs(values[1]) > ACC || Math.abs(values[2]) > ACC)) {

                Log.i("sensor", "running");

                Toast.makeText(getApplicationContext(), "Es wird gewackelt", Toast.LENGTH_SHORT).show();
                RandomClick(null);
            }
        }
    }



    private void registerSenser() {
        boolean done;
        done = sensor.registerListener(this,
                sensor.getDefaultSensor(Sensor.TYPE_ACCELEROMETER),
                // Es gibt: SENSOR_DELAY_UI, SENSOR_DELAY_FASTEST, SENSOR_DELAY_GAME usw.，
                //Je nach Anwendung erfordert es unterschiedliche Reaktionsgeschwindigkeiten
                SensorManager.SENSOR_DELAY_NORMAL);
        if (!done) {
            Toast.makeText(this, "Sensor wird nicht unterstützt!", Toast.LENGTH_SHORT).show();
            switch_bool = false;
        }
        Log.i("sensor", "register");
    }

    private void unregisterSenser() {
        sensor.unregisterListener(this);
        Log.i("sensor", "unregister");
    }





    public static int randInt(int min, int max) {
        Random rand = new Random();

        // nextInt is normally exclusive of the top value,
        // so add 1 to make it inclusive
        int randomNum = rand.nextInt((max - min) + 1) + min;

        return randomNum;
    }



    public void RandomClick (View v) {
        String binZahl = "";

        int zufallsZahl = randInt(1,6);

        binZahl = Integer.toString( zufallsZahl ) ;
        TextView ergebnis = (TextView) findViewById(R.id.textView);
        ergebnis.setText(binZahl);

        ImageView bild = (ImageView) findViewById(R.id.imageView);


        switch (zufallsZahl) {
            case 1:  bild.setImageResource(R.drawable.i_1_dice);
                break;
            case 2:  bild.setImageResource(R.drawable.i_2_dice);
                break;
            case 3:  bild.setImageResource(R.drawable.i_3_dice);
                break;
            case 4:  bild.setImageResource(R.drawable.i_4_dice);
                break;
            case 5: bild.setImageResource(R.drawable.i_5_dice);
                break;
            case 6:  bild.setImageResource(R.drawable.i_6_dice);
                break;
            default: bild.setImageResource(R.drawable.i_3_dice);
                break;
        }


    }
}
