package com.example.calc.bday;


import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v7.app.AppCompatActivity;   //hier v7
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;   //hier v4 !!!!
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;


import java.util.Locale;

import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.*;
import org.joda.time.*;

import java.util.*;  //für: .toString
import java.io.*;  //fürs speichern und so

import java.util.ArrayList;


public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
    }


    //This example is from: https://www.androidauthority.com/how-to-create-android-notifications-707254/
    //With own supplements/additions...
    //Also have a look at this: https://developer.android.com/training/notify-user/build-notification

    //Enable notification in the build.gradle on module-level !!!!!!!!!!!!!!!
    public void sendNotification(View view) {

        //Get an instance of NotificationManager//
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this);

        //Set the priority. The normal priority is default (default doesn't need to be set)
        //mBuilder.setPriority(NotificationCompat.PRIORITY_DEFAULT);
        //mBuilder.setPriority(NotificationCompat.PRIORITY_HIGH);
        //mBuilder.setPriority(NotificationCompat.PRIORITY_MAX);



        //Which activity should be opened, when the user tips on the notification?
        //This is optional!
        Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse("https://www.google.com/"));  //open google in users default browser
        PendingIntent pendingIntent = PendingIntent.getActivity(this, 0, intent, 0);
        mBuilder.setContentIntent(pendingIntent);


        //Set the text, titel and icon for the notification:
        mBuilder.setSmallIcon(R.drawable.preferences_system_notifications_icon);
        mBuilder.setContentTitle("My notification titel");
        mBuilder.setContentText("This is a text. Click me to open google in your browser.");


        // When you issue multiple notifications about the same type of event,
        // it’s best practice for your app to try to update an existing notification
        // with this new information, rather than immediately creating a new notification.
        // If you want to update this notification at a later date, you need to assign it an ID.
        // You can then use this ID whenever you issue a subsequent notification.
        // If the previous notification is still visible, the system will update this existing notification,
        // rather than create a new one. In this example, the notification’s ID is 001//


        //deprecated:
        // Gets an instance of the NotificationManager service
        //NotificationManager mNotificationManager =(NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
        //NotificationManager.notify().mNotificationManager.notify(001, mBuilder.build());

        //new:
        NotificationManagerCompat notificationManager = NotificationManagerCompat.from(this);
        notificationManager.notify(001, mBuilder.build());


    }










	//Android Saving file example:
    public void and_save(String toSave) 
    {

        String filename = "myfile";
        String fileContents = toSave;
        FileOutputStream outputStream;

        try {

            File file = new File(filename);
            Toast.makeText(this, "SAVE - anhängen an existierende datei", Toast.LENGTH_SHORT).show();
            outputStream = openFileOutput(filename, Context.MODE_APPEND);   //anhängen an existierende datei
            //outputStream = openFileOutput(filename, Context.MODE_PRIVATE);   //wenn die datei noch nicht existiert, dann neuerstellen und private rechte geben (standard)


            /*
            File file = new File(filename);
            if(file.exists())
            {
                Toast.makeText(this, "SAVE - anhängen an existierende datei", Toast.LENGTH_SHORT).show();
                outputStream = openFileOutput(filename, Context.MODE_APPEND);   //anhängen an existierende datei
            }
            else
            {  //existiert noch nicht, also erstellen:
                Toast.makeText(this, "SAVE - existiert noch nicht, also erstellen", Toast.LENGTH_SHORT).show();
                outputStream = openFileOutput(filename, Context.MODE_PRIVATE);
            }
            */

            outputStream.write(fileContents.getBytes());
            outputStream.close();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }





   //Reading/Open a file in Android and give it back as a String
    public String read_file() {     //This customized example is from: https://stackoverflow.com/questions/14768191/how-do-i-read-the-file-content-from-the-internal-storage-android-app/14768380 
        try {
            String filename = "myfile";
            Context context = getApplicationContext();

            FileInputStream fis = context.openFileInput(filename);
            InputStreamReader isr = new InputStreamReader(fis, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(isr);
            StringBuilder sb = new StringBuilder();
            String line;

            while ((line = bufferedReader.readLine()) != null)
            {
                sb.append(line).append("\n");
            }
            return sb.toString();

        } catch (FileNotFoundException e) {
            return "";
        } catch (UnsupportedEncodingException e) {
            return "";
        } catch (IOException e) {
            return "";
        }



    }



//Bricht/Splittet einen übergebenen String an den Umbrüchen auf und packt sie nacheinander in eine ArrayListe rein, so dass man sie später Zeilenweise auslesen kann.
    public ArrayList makeList(String toDo)
    {
        ArrayList<String> ret = new ArrayList<String>();
        String lines[] = toDo.split("\\r?\\n");   //Wir splitten das Array an einem Umbruch. Die einzelnen Teile werden erst in einem String Array abgespeichert

        for (int i=0; i < lines.length; i++)    //Da wir ja eigentlich eine ArrayListe haben wollten und kein simples Array, gehen wir eben das Array durch
        {										//und speichern die einzelnen Inhaltet des Arrays in der ArrayListe.
            ret.add( lines[i] );
        }

        return ret;
    }




//Wenn man auf den Button load klickt:
    public void openLoadBla(View v) {

        EditText memo = (EditText) findViewById(R.id.editText);
        memo.setText("");  //leer machen

        String blub = "";
        blub =  read_file();  //Wir lesen die Datei ein und bekommen einen String zurück
   
        ArrayList<String> sortedNames = makeList(blub);   //Wir wandeln den String in eine ArrayList um. Für jeden Umbruch wird ein neuer Eintrag in der Liste gemacht!


           for (int i=0; i < sortedNames.size(); i++)
          {
              memo.append("i="+i+"#"+ sortedNames.get(i) +"\n" );    //Wir können nun die einzelnen Zeilen bequem durchgehen
          }

    }




    public void test(View v)
    {

        EditText memo = (EditText) findViewById(R.id.editText);

        memo.setText("");  //leer machen




        DateTimeFormatter formatter = DateTimeFormat.forPattern("dd.MM.yyyy"); //Auch möglich die Uhrzeit mit zu übergeben: DateTimeFormat.forPattern("dd.MM.yyyy HH:mm:ss");
                                                                               //Es ist auch möglich es in einem anderem Datumsformat zu übergeben, bsp.: DateTimeFormat.forPattern("dd/MM/yyyy");
        DateTime aktDatum = new DateTime();

        memo.append("Aktuelles Jahr:            " + aktDatum.getYear());
        memo.append("\n");
        memo.append("Aktueller Monat:           " + aktDatum.getMonthOfYear());
        memo.append("\n");
        memo.append("Aktueller Tag im Monat:    " + aktDatum.getDayOfMonth());
        memo.append("\n");

  
  		LocalTime time = new LocalTime();
        String formatted_time = time.toString("HH:mm:ss");  //Auch möglich ohne Sekunden: time.toString("HH:mm");
        memo.append("Aktuelle Uhrzeit ist: "+formatted_time + " \n");

  



        and_save("The saved Time: "+ formatted_time + "\n");
    
    }








    }
