package com.mentoring.asuper.geburtstagsreminder;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.NotificationCompat;
import android.widget.Toast;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;

public class ReminderAlarm extends BroadcastReceiver {

    @Override
    public void onReceive(Context arg0, Intent arg1) {
        Toast.makeText(arg0, "I'm running", Toast.LENGTH_SHORT).show();
        DateTimeFormatter formatter = DateTimeFormat.forPattern("dd.MM.yyyy");
        String fileData = read_file(arg0);
        if(fileData != "") {
            ArrayList<String> data = makeList(fileData);
            DateTime d = new DateTime();
            String s = d.getDayOfMonth() + "." + d.getMonthOfYear() + "." + d.getYear();
            DateTime aktDatum = formatter.parseDateTime(s).withTimeAtStartOfDay();
            int i = 1;
            for (Iterator<String> it = data.iterator(); it.hasNext(); ) {
                String vorname = it.next();
                String nachname = it.next();
                DateTime dt = formatter.parseDateTime(it.next() + "." + it.next() + "." + aktDatum.getYear()).withTimeAtStartOfDay();
                if (dt.equals(aktDatum)) {
                    sendNotification(arg0, vorname, nachname, i);
                    i++;
                }
            }
        }
    }
    //http://pad.spline.de/0C6H58LJ1h
   public void sendNotification(Context context, String vorname, String nachname, int id) {
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context);

        mBuilder.setSmallIcon(R.mipmap.ic_launcher);
        mBuilder.setContentTitle("Geburtstag!!! :D");
        mBuilder.setContentText(vorname + " " + nachname + " hat heute Geburtstag :)");
        mBuilder.setDefaults(NotificationCompat.DEFAULT_SOUND);

        PendingIntent contentIntent = PendingIntent.getActivity(context, 0, new Intent(context, MainActivity.class), PendingIntent.FLAG_UPDATE_CURRENT);
        mBuilder.setContentIntent(contentIntent);

        NotificationManager nNotifManager = (NotificationManager) context.getSystemService(context.NOTIFICATION_SERVICE);
        nNotifManager.notify(id, mBuilder.build());

   }

   public String read_file(Context context) {     //This customized example is from: https://stackoverflow.com/questions/14768191/how-do-i-read-the-file-content-from-the-internal-storage-android-app/14768380
        try {
            String filename = "myfile";
            FileInputStream fis = context.openFileInput(filename);
            InputStreamReader isr = new InputStreamReader(fis, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(isr);
            StringBuilder sb = new StringBuilder();
            String line;
            while ((line = bufferedReader.readLine()) != null)
            {
                sb.append(line).append("\n");
            }
            return sb.toString();
        } catch (FileNotFoundException e) {
            return "";
        } catch (UnsupportedEncodingException e) {
            return "";
        } catch (IOException e) {
            return "";
        }
    }

    public ArrayList<String> makeList(String toDo) {
        ArrayList<String> ret = new ArrayList<String>();
        String lines[] = toDo.split("\\r?\\n");   //Wir splitten das Array an einem Umbruch. Die einzelnen Teile werden erst in einem String Array abgespeichert
        for (int i = 0; i < lines.length; i++) {   //Da wir ja eigentlich eine ArrayListe haben wollten und kein simples Array, gehen wir eben das Array durch
            // und speichern die einzelnen Inhaltet des Arrays in der ArrayListe.
            ret.add(lines[i]);
        }
        return ret;
    }

}